GO
IF EXISTS(SELECT * FROM sys.objects
		  WHERE 
			 object_id = OBJECT_ID(N'[dbo].[P_PDV_VD_IT_COMIS_RECALC_ANTIGO_EXECUTE_ALL]')
			 AND type IN(N'P', N'PC'))
    BEGIN
        DROP PROCEDURE [dbo].[P_PDV_VD_IT_COMIS_RECALC_ANTIGO_EXECUTE_ALL]
    END;
GO
GO
--EXEC dbo.P_PDV_VD_IT_COMIS_RECALC_ANTIGO_EXECUTE_ALL
CREATE PROCEDURE [dbo].[P_PDV_VD_IT_COMIS_RECALC_ANTIGO_EXECUTE_ALL] @DT_INI DATE = NULL,
                                                              @DT_FIM DATE = NULL
AS
    BEGIN

        PRINT 'Inicio do recalculo';
        SET NOCOUNT ON;
        DECLARE @CD_FILIAL VARCHAR(5);
        IF @DT_INI IS NULL
            BEGIN
                SELECT @DT_INI = GETDATE();
                SET @DT_FIM = @DT_INI;
                SET @DT_INI = DATEADD(DAY,-3,@DT_INI);
            END;

        DECLARE filiaisComissao CURSOR FAST_FORWARD
        FOR SELECT CONVERT( VARCHAR(10), CD_FILIAL)
            FROM PRC_FILIAL
            ORDER BY CD_FILIAL;
        OPEN filiaisComissao;
        FETCH NEXT FROM filiaisComissao INTO @CD_FILIAL;
        WHILE @@FETCH_STATUS = 0
            BEGIN
                PRINT 'Filial '+@CD_FILIAL+' '+CONVERT(VARCHAR, @DT_INI, 112)+' a '+CONVERT(VARCHAR, @DT_FIM, 112);
                
			 PRINT 'Calculando cupons fiscais ';
                EXEC dbo.P_PDV_VD_IT_COMIS_RECALC_ANTIGO 1, @CD_FILIAL, @DT_INI, @DT_FIM;
                
                FETCH NEXT FROM filiaisComissao INTO @CD_FILIAL;
            END;
        PRINT 'Concluido.';
        CLOSE filiaisComissao;
        DEALLOCATE filiaisComissao;
    END;